/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Estimator.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )


/*******************************************************************
* Function Name: Estimator
* Description: constructor
********************************************************************/
Estimator::Estimator( const string &name )
: Atomic( name )
, Projectin( addInputPort( "Projectin" ) )
, Projectsize( addInputPort( "Projectsize" ) )
, reqtime( addOutputPort( "reqtime" ) )
, designtime( addOutputPort( "designtime" ) )
, imptime( addOutputPort( "imptime" ) )
, preparationTime( 0, 0, 0, 0 )
{

	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Estimator::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	
 	ProjIn = 0;
 	projSize = 0;
 	reqtimeout = 0;
	designtimeout = 0;
	imptimeout = 0;
 	this->passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Estimator::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	this->sigma = nextChange();
	this->elapsed = msg.time()-lastChange();
 	this->timeLeft = this->sigma - this->elapsed;

		if( msg.port() == Projectin )
		{
			ProjIn = msg.value(); //static_cast < int > (msg.value());
		}
		if(msg.port() == Projectsize){
			projSize = msg.value();//static_cast < int > (msg.value()); // get the input value in hours
		}
	if ( this->state() == passive )
		{
		cout<<"Proj input   "<<ProjIn<<"  "<<projSize;
		if(ProjIn !=0 && projSize != 0){
			reqtimeout = (1 * projSize)/10;
			designtimeout = (2 * projSize)/10;
			imptimeout = (7 * projSize)/10;
			holdIn( active, preparationTime );
		}

	}


	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Estimator::internalFunction( const InternalMessage & )
{
	//TODO: implement the internal function here
	if(ProjIn !=0 && projSize != 0){
		reqtimeout = 0;
		designtimeout = 0;
		imptimeout = 0;
		projSize = 0;
		ProjIn = 0;
	}
	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn(passive, this->sigma );

	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Estimator::outputFunction( const InternalMessage &msg )
{
	//TODO: implement the output function here
	// remember you can use sendOutput(time, outputPort, value) function.
	//sendOutput( msg.time(), reqtime, 1) ;

	if(ProjIn != 0 && projSize !=0 && reqtimeout!=0 && designtimeout!=0 && imptimeout!=0){
		sendOutput( msg.time(), reqtime , reqtimeout ) ; //reqtimeout
		sendOutput( msg.time(), designtime , designtimeout ) ; //designtimeout
		sendOutput( msg.time(), imptime , imptimeout ) ; //imptimeout
	}
	return *this;

}

Estimator::~Estimator()
{
	//TODO: add destruction code here. Free distribution memory, etc. 
}
